<?php

use App\Http\Controllers\SettingsController;
use App\Http\Controllers\Settings\TwoFactorAuthenticationController;
use Illuminate\Support\Facades\Route;

Route::middleware('auth')->group(function () {
    // Main settings page
    Route::get('settings', [SettingsController::class, 'index'])->name('settings.index');

    // Profile updates
    Route::put('settings/profile', [SettingsController::class, 'updateProfile'])->name('settings.profile.update');

    // Password updates
    Route::put('settings/password', [SettingsController::class, 'updatePassword'])
        ->middleware('throttle:6,1')
        ->name('settings.password.update');

    // Account deletion
    Route::delete('settings/profile', [SettingsController::class, 'deleteAccount'])->name('settings.profile.destroy');

    // Two-factor authentication
    Route::get('settings/two-factor', [TwoFactorAuthenticationController::class, 'show'])
        ->name('two-factor.show');
});
