<?php

use App\Http\Controllers\Admin\SectionController as AdminSectionController;
use App\Http\Controllers\SectionController;
use Illuminate\Support\Facades\Route;

// Authenticated section routes (contributors and admins) - MUST come before public routes
Route::middleware(['auth', 'verified'])->group(function () {
    // My sections route
    Route::get('/my-sections', [\App\Http\Controllers\MySectionsController::class, 'index'])->name('my-sections.index');

    // Section routes - specific routes MUST come before dynamic {section} routes
    Route::prefix('sections')->name('sections.')->group(function () {
        // List all sections
        Route::get('/', [SectionController::class, 'index'])->name('index');

        // Create section (MUST be before {section:slug})
        Route::get('/create', [SectionController::class, 'create'])->name('create');
        Route::post('/', [SectionController::class, 'store'])->name('store');

        // Edit section (MUST be before {section:slug})
        Route::get('/{section}/edit', [SectionController::class, 'edit'])->name('edit');
        Route::put('/{section}', [SectionController::class, 'update'])->name('update');

        // Other specific actions
        Route::post('/{section}/resubmit', [SectionController::class, 'resubmit'])->name('resubmit');
        Route::delete('/{section}', [SectionController::class, 'destroy'])->name('destroy');
        Route::get('/{section}/versions/{version}/code', [SectionController::class, 'getCode'])->name('code');

        // Show section (MUST be last among GET routes to avoid catching /create, /edit, etc.)
        Route::get('/{section:slug}', [SectionController::class, 'show'])->name('show');
    });

    // Category management (accessible by contributors and admins)
    Route::middleware('can:manage-categories')->prefix('admin')->name('admin.')->group(function () {
        Route::resource('categories', \App\Http\Controllers\Admin\CategoryController::class);
    });

    // Admin routes
    Route::middleware('can:approve,App\Models\Section')->prefix('admin')->name('admin.')->group(function () {
        // Section management
        Route::prefix('sections')->name('sections.')->group(function () {
            Route::get('/', [AdminSectionController::class, 'index'])->name('index');
            Route::get('/{section}', [AdminSectionController::class, 'show'])->name('show');
            Route::post('/{section}/approve', [AdminSectionController::class, 'approve'])->name('approve');
            Route::post('/{section}/reject', [AdminSectionController::class, 'reject'])->name('reject');
            Route::delete('/{section}', [AdminSectionController::class, 'destroy'])->name('destroy');
            Route::post('/bulk-approve', [AdminSectionController::class, 'bulkApprove'])->name('bulk-approve');
            Route::post('/bulk-reject', [AdminSectionController::class, 'bulkReject'])->name('bulk-reject');
        });

        // User management
        Route::prefix('users')->name('users.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\UserController::class, 'index'])->name('index');
            Route::get('/create', [\App\Http\Controllers\Admin\UserController::class, 'create'])->name('create');
            Route::post('/', [\App\Http\Controllers\Admin\UserController::class, 'store'])->name('store');
            Route::get('/{user}/edit', [\App\Http\Controllers\Admin\UserController::class, 'edit'])->name('edit');
            Route::put('/{user}', [\App\Http\Controllers\Admin\UserController::class, 'update'])->name('update');
            Route::put('/{user}/password', [\App\Http\Controllers\Admin\UserController::class, 'updatePassword'])->name('update-password');
            Route::delete('/{user}', [\App\Http\Controllers\Admin\UserController::class, 'destroy'])->name('destroy');
        });
    });
});
