export type SectionStatus = 'pending' | 'approved' | 'rejected';
export type Framework = 'html' | 'react' | 'vue' | 'angular';
export type Styling = 'tailwind' | 'bootstrap';

export interface User {
    id: number;
    name: string;
    email: string;
    role: 'user' | 'contributor' | 'admin';
    created_at: string;
}

export interface Category {
    id: number;
    name: string;
    slug: string;
    description: string | null;
    icon: string | null;
    color: string | null;
}

export interface SectionVersion {
    id: number;
    section_id: number;
    framework: Framework;
    styling: Styling;
    code: string;
    dependencies: string[] | null;
    notes: string | null;
    version: string;
    is_active: boolean;
    created_at: string;
    updated_at: string;
}

export interface Section {
    id: number;
    name: string;
    slug: string;
    description: string | null;
    category_id: number;
    category?: Category;
    tags: string[] | null;
    thumbnail: string | null;
    status: SectionStatus;
    user_id: number;
    approved_by: number | null;
    approved_at: string | null;
    rejection_reason: string | null;
    views_count: number;
    copies_count: number;
    created_at: string;
    updated_at: string;
    user?: User;
    approver?: User;
    versions?: SectionVersion[];
}

export interface PaginatedSections {
    data: Section[];
    current_page: number;
    last_page: number;
    per_page: number;
    total: number;
    from: number;
    to: number;
}

export interface SectionFilters {
    category?: string;
    search?: string;
    tags?: string;
    sort?: 'latest' | 'popular' | 'most_copied' | 'oldest' | string;
}

export interface AdminSectionStats {
    total: number;
    pending: number;
    approved: number;
    rejected: number;
}
