import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import AppLayout from '@/layouts/app-layout';
import { Head } from '@inertiajs/react';
import { Code, Github, Heart, Users } from 'lucide-react';

export default function About() {
    return (
        <AppLayout>
            <Head title="About" />

            <div className="container mx-auto px-4 py-8 max-w-4xl">
                <div className="mb-8">
                    <h1 className="text-4xl font-bold mb-2">About Softihub</h1>
                    <p className="text-muted-foreground text-lg">
                        A modern platform for sharing and discovering code sections
                    </p>
                </div>

                <div className="space-y-6">
                    {/* Mission */}
                    <Card>
                        <CardHeader>
                            <CardTitle className="flex items-center">
                                <Heart className="mr-2 h-5 w-5 text-red-500" />
                                Our Mission
                            </CardTitle>
                        </CardHeader>
                        <CardContent>
                            <p className="text-muted-foreground">
                                Softihub is dedicated to empowering developers by providing a collaborative
                                platform where they can share, discover, and learn from high-quality code
                                sections. We believe in the power of community-driven knowledge sharing to
                                accelerate software development and foster innovation.
                            </p>
                        </CardContent>
                    </Card>

                    {/* Features */}
                    <Card>
                        <CardHeader>
                            <CardTitle className="flex items-center">
                                <Code className="mr-2 h-5 w-5 text-blue-500" />
                                Key Features
                            </CardTitle>
                        </CardHeader>
                        <CardContent>
                            <ul className="space-y-3">
                                <li className="flex items-start">
                                    <span className="mr-2 mt-1 h-1.5 w-1.5 rounded-full bg-primary" />
                                    <div>
                                        <strong>Code Section Sharing:</strong> Share reusable code snippets
                                        with syntax highlighting and version control
                                    </div>
                                </li>
                                <li className="flex items-start">
                                    <span className="mr-2 mt-1 h-1.5 w-1.5 rounded-full bg-primary" />
                                    <div>
                                        <strong>Category Organization:</strong> Browse sections by categories
                                        for easy discovery
                                    </div>
                                </li>
                                <li className="flex items-start">
                                    <span className="mr-2 mt-1 h-1.5 w-1.5 rounded-full bg-primary" />
                                    <div>
                                        <strong>Version Management:</strong> Track changes and maintain
                                        multiple versions of your code sections
                                    </div>
                                </li>
                                <li className="flex items-start">
                                    <span className="mr-2 mt-1 h-1.5 w-1.5 rounded-full bg-primary" />
                                    <div>
                                        <strong>Admin Moderation:</strong> Quality control through admin
                                        approval system
                                    </div>
                                </li>
                                <li className="flex items-start">
                                    <span className="mr-2 mt-1 h-1.5 w-1.5 rounded-full bg-primary" />
                                    <div>
                                        <strong>User Roles:</strong> Flexible permission system with User,
                                        Contributor, and Admin roles
                                    </div>
                                </li>
                            </ul>
                        </CardContent>
                    </Card>

                    {/* Technology */}
                    <Card>
                        <CardHeader>
                            <CardTitle className="flex items-center">
                                <Github className="mr-2 h-5 w-5" />
                                Built With
                            </CardTitle>
                        </CardHeader>
                        <CardContent>
                            <div className="grid grid-cols-2 gap-4">
                                <div>
                                    <h4 className="font-semibold mb-2">Backend</h4>
                                    <ul className="space-y-1 text-sm text-muted-foreground">
                                        <li>• Laravel 12</li>
                                        <li>• PHP 8.4</li>
                                        <li>• MySQL Database</li>
                                        <li>• Laravel Fortify</li>
                                    </ul>
                                </div>
                                <div>
                                    <h4 className="font-semibold mb-2">Frontend</h4>
                                    <ul className="space-y-1 text-sm text-muted-foreground">
                                        <li>• React 19</li>
                                        <li>• Inertia.js v2</li>
                                        <li>• TypeScript</li>
                                        <li>• Tailwind CSS v4</li>
                                        <li>• shadcn/ui</li>
                                    </ul>
                                </div>
                            </div>
                        </CardContent>
                    </Card>

                    {/* Team */}
                    <Card>
                        <CardHeader>
                            <CardTitle className="flex items-center">
                                <Users className="mr-2 h-5 w-5 text-green-500" />
                                For Developers, By Developers
                            </CardTitle>
                        </CardHeader>
                        <CardContent>
                            <p className="text-muted-foreground">
                                Softihub is built by a team of passionate developers who understand the
                                challenges of modern software development. We're committed to creating
                                tools that make developers' lives easier and more productive.
                            </p>
                        </CardContent>
                    </Card>

                    {/* Version */}
                    <Card>
                        <CardContent className="pt-6">
                            <div className="text-center text-sm text-muted-foreground">
                                <p>Softihub v1.0.0</p>
                                <p className="mt-1">© 2025 Softihub. All rights reserved.</p>
                            </div>
                        </CardContent>
                    </Card>
                </div>
            </div>
        </AppLayout>
    );
}
