import { Breadcrumbs } from '@/components/breadcrumbs';
import { SidebarTrigger, useSidebar } from '@/components/ui/sidebar';
import { useAppearance } from '@/hooks/use-appearance';
import { cn } from '@/lib/utils';
import { type BreadcrumbItem as BreadcrumbItemType } from '@/types';
import { Moon, Sun } from 'lucide-react';
export function AppSidebarHeader({
    breadcrumbs = [],
}: {
    breadcrumbs?: BreadcrumbItemType[];
}) {

    const { updateAppearance } = useAppearance();
    const { state } = useSidebar();

    return (
        <header className={cn(
            "fixed top-0 z-50 flex justify-between h-16 shrink-0 items-center gap-2 border-b border-sidebar-border/50 bg-background/95 backdrop-blur max-md:w-full supports-backdrop-filter:bg-background/60 px-6 transition-all ease-linear group-has-data-[collapsible=icon]/sidebar-wrapper:h-12 md:px-4",
            state === "expanded" ? "md:w-[calc(100%-16rem)]" : "md:w-[calc(100%-3rem)]"
        )}>
            <div className="flex items-center gap-2">
                <SidebarTrigger className="-ml-1" />
                <Breadcrumbs breadcrumbs={breadcrumbs} />
            </div>
            <div className="relative flex items-center space-x-1">

                <button
                    onClick={() => updateAppearance('light')}
                    className={cn(
                        'w-full hidden dark:flex items-center rounded-sm text-sm transition-colors',
                    )}
                >
                    <Sun className="mr-2 h-4 w-4" />

                </button>
                <button
                    onClick={() => updateAppearance('dark')}
                    className={cn(
                        'w-full dark:hidden flex items-center rounded-sm text-sm transition-colors',
                    )}
                >
                    <Moon className="mr-2 h-4 w-4" />

                </button>



            </div>
        </header>
    );
}
