import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Admin\SectionController::index
* @see app/Http/Controllers/Admin/SectionController.php:15
* @route '/admin/sections'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/admin/sections',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Admin\SectionController::index
* @see app/Http/Controllers/Admin/SectionController.php:15
* @route '/admin/sections'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Admin\SectionController::index
* @see app/Http/Controllers/Admin/SectionController.php:15
* @route '/admin/sections'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Admin\SectionController::index
* @see app/Http/Controllers/Admin/SectionController.php:15
* @route '/admin/sections'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Admin\SectionController::index
* @see app/Http/Controllers/Admin/SectionController.php:15
* @route '/admin/sections'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Admin\SectionController::index
* @see app/Http/Controllers/Admin/SectionController.php:15
* @route '/admin/sections'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Admin\SectionController::index
* @see app/Http/Controllers/Admin/SectionController.php:15
* @route '/admin/sections'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\Admin\SectionController::show
* @see app/Http/Controllers/Admin/SectionController.php:65
* @route '/admin/sections/{section}'
*/
export const show = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/admin/sections/{section}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Admin\SectionController::show
* @see app/Http/Controllers/Admin/SectionController.php:65
* @route '/admin/sections/{section}'
*/
show.url = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { section: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { section: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            section: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        section: typeof args.section === 'object'
        ? args.section.id
        : args.section,
    }

    return show.definition.url
            .replace('{section}', parsedArgs.section.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Admin\SectionController::show
* @see app/Http/Controllers/Admin/SectionController.php:65
* @route '/admin/sections/{section}'
*/
show.get = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Admin\SectionController::show
* @see app/Http/Controllers/Admin/SectionController.php:65
* @route '/admin/sections/{section}'
*/
show.head = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Admin\SectionController::show
* @see app/Http/Controllers/Admin/SectionController.php:65
* @route '/admin/sections/{section}'
*/
const showForm = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Admin\SectionController::show
* @see app/Http/Controllers/Admin/SectionController.php:65
* @route '/admin/sections/{section}'
*/
showForm.get = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Admin\SectionController::show
* @see app/Http/Controllers/Admin/SectionController.php:65
* @route '/admin/sections/{section}'
*/
showForm.head = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\Admin\SectionController::approve
* @see app/Http/Controllers/Admin/SectionController.php:77
* @route '/admin/sections/{section}/approve'
*/
export const approve = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: approve.url(args, options),
    method: 'post',
})

approve.definition = {
    methods: ["post"],
    url: '/admin/sections/{section}/approve',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Admin\SectionController::approve
* @see app/Http/Controllers/Admin/SectionController.php:77
* @route '/admin/sections/{section}/approve'
*/
approve.url = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { section: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { section: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            section: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        section: typeof args.section === 'object'
        ? args.section.id
        : args.section,
    }

    return approve.definition.url
            .replace('{section}', parsedArgs.section.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Admin\SectionController::approve
* @see app/Http/Controllers/Admin/SectionController.php:77
* @route '/admin/sections/{section}/approve'
*/
approve.post = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: approve.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Admin\SectionController::approve
* @see app/Http/Controllers/Admin/SectionController.php:77
* @route '/admin/sections/{section}/approve'
*/
const approveForm = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: approve.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Admin\SectionController::approve
* @see app/Http/Controllers/Admin/SectionController.php:77
* @route '/admin/sections/{section}/approve'
*/
approveForm.post = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: approve.url(args, options),
    method: 'post',
})

approve.form = approveForm

/**
* @see \App\Http\Controllers\Admin\SectionController::reject
* @see app/Http/Controllers/Admin/SectionController.php:91
* @route '/admin/sections/{section}/reject'
*/
export const reject = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: reject.url(args, options),
    method: 'post',
})

reject.definition = {
    methods: ["post"],
    url: '/admin/sections/{section}/reject',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Admin\SectionController::reject
* @see app/Http/Controllers/Admin/SectionController.php:91
* @route '/admin/sections/{section}/reject'
*/
reject.url = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { section: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { section: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            section: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        section: typeof args.section === 'object'
        ? args.section.id
        : args.section,
    }

    return reject.definition.url
            .replace('{section}', parsedArgs.section.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Admin\SectionController::reject
* @see app/Http/Controllers/Admin/SectionController.php:91
* @route '/admin/sections/{section}/reject'
*/
reject.post = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: reject.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Admin\SectionController::reject
* @see app/Http/Controllers/Admin/SectionController.php:91
* @route '/admin/sections/{section}/reject'
*/
const rejectForm = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: reject.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Admin\SectionController::reject
* @see app/Http/Controllers/Admin/SectionController.php:91
* @route '/admin/sections/{section}/reject'
*/
rejectForm.post = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: reject.url(args, options),
    method: 'post',
})

reject.form = rejectForm

/**
* @see \App\Http\Controllers\Admin\SectionController::destroy
* @see app/Http/Controllers/Admin/SectionController.php:109
* @route '/admin/sections/{section}'
*/
export const destroy = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/admin/sections/{section}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\Admin\SectionController::destroy
* @see app/Http/Controllers/Admin/SectionController.php:109
* @route '/admin/sections/{section}'
*/
destroy.url = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { section: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { section: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            section: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        section: typeof args.section === 'object'
        ? args.section.id
        : args.section,
    }

    return destroy.definition.url
            .replace('{section}', parsedArgs.section.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Admin\SectionController::destroy
* @see app/Http/Controllers/Admin/SectionController.php:109
* @route '/admin/sections/{section}'
*/
destroy.delete = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\Admin\SectionController::destroy
* @see app/Http/Controllers/Admin/SectionController.php:109
* @route '/admin/sections/{section}'
*/
const destroyForm = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Admin\SectionController::destroy
* @see app/Http/Controllers/Admin/SectionController.php:109
* @route '/admin/sections/{section}'
*/
destroyForm.delete = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

/**
* @see \App\Http\Controllers\Admin\SectionController::bulkApprove
* @see app/Http/Controllers/Admin/SectionController.php:119
* @route '/admin/sections/bulk-approve'
*/
export const bulkApprove = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: bulkApprove.url(options),
    method: 'post',
})

bulkApprove.definition = {
    methods: ["post"],
    url: '/admin/sections/bulk-approve',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Admin\SectionController::bulkApprove
* @see app/Http/Controllers/Admin/SectionController.php:119
* @route '/admin/sections/bulk-approve'
*/
bulkApprove.url = (options?: RouteQueryOptions) => {
    return bulkApprove.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Admin\SectionController::bulkApprove
* @see app/Http/Controllers/Admin/SectionController.php:119
* @route '/admin/sections/bulk-approve'
*/
bulkApprove.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: bulkApprove.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Admin\SectionController::bulkApprove
* @see app/Http/Controllers/Admin/SectionController.php:119
* @route '/admin/sections/bulk-approve'
*/
const bulkApproveForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: bulkApprove.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Admin\SectionController::bulkApprove
* @see app/Http/Controllers/Admin/SectionController.php:119
* @route '/admin/sections/bulk-approve'
*/
bulkApproveForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: bulkApprove.url(options),
    method: 'post',
})

bulkApprove.form = bulkApproveForm

/**
* @see \App\Http\Controllers\Admin\SectionController::bulkReject
* @see app/Http/Controllers/Admin/SectionController.php:142
* @route '/admin/sections/bulk-reject'
*/
export const bulkReject = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: bulkReject.url(options),
    method: 'post',
})

bulkReject.definition = {
    methods: ["post"],
    url: '/admin/sections/bulk-reject',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Admin\SectionController::bulkReject
* @see app/Http/Controllers/Admin/SectionController.php:142
* @route '/admin/sections/bulk-reject'
*/
bulkReject.url = (options?: RouteQueryOptions) => {
    return bulkReject.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Admin\SectionController::bulkReject
* @see app/Http/Controllers/Admin/SectionController.php:142
* @route '/admin/sections/bulk-reject'
*/
bulkReject.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: bulkReject.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Admin\SectionController::bulkReject
* @see app/Http/Controllers/Admin/SectionController.php:142
* @route '/admin/sections/bulk-reject'
*/
const bulkRejectForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: bulkReject.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Admin\SectionController::bulkReject
* @see app/Http/Controllers/Admin/SectionController.php:142
* @route '/admin/sections/bulk-reject'
*/
bulkRejectForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: bulkReject.url(options),
    method: 'post',
})

bulkReject.form = bulkRejectForm

const SectionController = { index, show, approve, reject, destroy, bulkApprove, bulkReject }

export default SectionController