<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create admin user
        User::firstOrCreate(
            ['email' => 'ikholil.bd@gmail.com'],
            [
                'name' => 'Ibrahim Kholilullah',
                'password' => bcrypt('password'),
                'role' => 'admin',
                'email_verified_at' => now(),
            ]
        );

        // Create contributor users
        User::firstOrCreate(
            ['email' => 'btouha007@gmail.com'],
            [
                'name' => 'LB Touha',
                'password' => bcrypt('password'),
                'role' => 'contributor',
                'email_verified_at' => now(),
            ]
        );

        User::firstOrCreate(
            ['email' => 'sarah.dev@gmail.com'],
            [
                'name' => 'Sarah Developer',
                'password' => bcrypt('password'),
                'role' => 'contributor',
                'email_verified_at' => now(),
            ]
        );

        User::firstOrCreate(
            ['email' => 'mike.designer@gmail.com'],
            [
                'name' => 'Mike Designer',
                'password' => bcrypt('password'),
                'role' => 'contributor',
                'email_verified_at' => now(),
            ]
        );
    }
}
