<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Fortify\TwoFactorAuthenticatable;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable, TwoFactorAuthenticatable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'role',
        'access_type',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'two_factor_secret',
        'two_factor_recovery_codes',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'two_factor_confirmed_at' => 'datetime',
        ];
    }

    public function isAdmin(): bool
    {
        return $this->role === 'admin';
    }

    public function isContributor(): bool
    {
        return $this->role === 'contributor';
    }

    public function canApprove(): bool
    {
        return $this->isAdmin();
    }

    /**
     * Check if user has web access.
     */
    public function hasWebAccess(): bool
    {
        return in_array($this->access_type, ['web', 'both']);
    }

    /**
     * Check if user has dashboard access.
     */
    public function hasDashboardAccess(): bool
    {
        return in_array($this->access_type, ['dashboard', 'both']);
    }

    /**
     * Get accessible category types for this user.
     */
    public function getAccessibleCategoryTypes(): array
    {
        if ($this->isAdmin() || $this->access_type === 'both') {
            return ['web', 'dashboard'];
        }

        return [$this->access_type];
    }
}
