<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SectionVersion extends Model
{
    use HasFactory;

    protected $fillable = [
        'section_id',
        'framework',
        'styling',
        'code',
        'dependencies',
        'notes',
        'version',
        'is_active',
    ];

    protected function casts(): array
    {
        return [
            'dependencies' => 'array',
            'is_active' => 'boolean',
        ];
    }

    public function section(): BelongsTo
    {
        return $this->belongsTo(Section::class);
    }
}
